//=============================================================================

/*:
 * @plugindesc YanflyEquipCoreのサブ画面に特殊パラメータを追加します。
 * 
 * @author LefTonbo
 *
 * @param Param Name Attack Times
 * @type string
 * @desc 攻撃回数の説明
 * @default 攻撃回数
 *
 * @param Param Name Total Damage
 * @type string
 * @desc 合計攻撃力の説明
 * @default 合計攻撃力
 *
 * @param Param Name Critical Damage
 * @type string
 * @desc クリティカル攻撃力の説明
 * @default クリティカル攻撃力
 *
 * @param Param Name Average Damage
 * @type string
 * @desc ダメージ期待値の説明
 * @default ダメージ期待値
 *
 */

//=============================================================================

var Imported = Imported || {};
Imported.LP_EquipExtraCompare = true;

var LeftPlugin = LeftPlugin || {};

LeftPlugin.Parameters = PluginManager.parameters('LP_EquipExtraCompare');
LeftPlugin.Param = LeftPlugin.Param || {};

LeftPlugin.Param.ParamNameAttackTimes = String(LeftPlugin.Parameters['Param Name Attack Times']);
LeftPlugin.Param.ParamNameTotalDamage = String(LeftPlugin.Parameters['Param Name Total Damage']);
LeftPlugin.Param.ParamNameCriticalDamage = String(LeftPlugin.Parameters['Param Name Critical Damage']);
LeftPlugin.Param.ParamNameAverageDamage = String(LeftPlugin.Parameters['Param Name Average Damage']);

//=============================================================================

function Window_StatCompareExtra() {
    this.initialize.apply(this, arguments);
}

//=============================================================================

(function () {

//=============================================================================
// Window_StatCompareExtra
//=============================================================================

Window_StatCompareExtra.prototype = Object.create(Window_StatCompare.prototype);
Window_StatCompareExtra.prototype.constructor = Window_StatCompareExtra;

Window_StatCompareExtra.prototype.initialize = function(wx, wy, ww, wh) {
    Window_Base.prototype.initialize.call(this, wx, wy, ww, wh);
    this._actor = null;
    this._tempActor = null;
    this.contents.fontSize = 20;
    this.refresh();
};

Window_StatCompareExtra.prototype.refresh = function() {
    this.contents.clear();
    if (!this._actor) return;
    var j = 0;
    var extras = ['atktime','alldmg','avgdmg'];
    for (var i = 0; i < extras.length; ++i) {
        this.drawItemAddition(0, this.lineHeight() * j, extras[i]);
        j++ ;
    }
    extras = ['pdr','mdr','eva','cri'];
    for (var i = 0; i < extras.length; ++i) {
        this.drawItemExtra(0, this.lineHeight() * j, extras[i]);
        j++ ;
    }
    extras = ['cridmg'];
    for (var i = 0; i < extras.length; ++i) {
        this.drawItemAddition(0, this.lineHeight() * j, extras[i]);
        j++ ;
    }
};

//=============================================================================

Window_StatCompareExtra.prototype.drawItemExtra = function(x, y, attr) {
    this.drawDarkRect(x, y, this.contents.width, this.lineHeight());
    this.drawParamNameExtra(y, attr);
    this.drawCurrentParamExtra(y, attr);
    this.drawRightArrow(y);
    if (!this._tempActor) return;
    this.drawNewParamExtra(y, attr);
    this.drawParamDifferenceExtra(y, attr);
};

Window_StatCompareExtra.prototype.drawParamNameExtra = function(y, attr) {
    var x = this.textPadding();
    var text = '';
    this.changeTextColor(this.systemColor());
    switch (attr) {
    case 'hit':
      text = Yanfly.Param.StatusAttr_hit;
      break;
    case 'eva':
      text = Yanfly.Param.StatusAttr_eva;
      break;
    case 'cri':
      text = Yanfly.Param.StatusAttr_cri;
      break;
    case 'cev':
      text = Yanfly.Param.StatusAttr_cev;
      break;
    case 'mev':
      text = Yanfly.Param.StatusAttr_mev;
      break;
    case 'mrf':
      text = Yanfly.Param.StatusAttr_mrf;
      break;
    case 'cnt':
      text = Yanfly.Param.StatusAttr_cnt;
      break;
    case 'hrg':
      text = Yanfly.Param.StatusAttr_hrg;
      break;
    case 'mrg':
      text = Yanfly.Param.StatusAttr_mrg;
      break;
    case 'trg':
      text = Yanfly.Param.StatusAttr_trg;
      break;
    case 'tgr':
      text = Yanfly.Param.StatusAttr_tgr;
      break;
    case 'grd':
      text = Yanfly.Param.StatusAttr_grd;
      break;
    case 'rec':
      text = Yanfly.Param.StatusAttr_rec;
      break;
    case 'pha':
      text = Yanfly.Param.StatusAttr_pha;
      break;
    case 'mcr':
      text = Yanfly.Param.StatusAttr_mcr;
      break;
    case 'tcr':
      text = Yanfly.Param.StatusAttr_tcr;
      break;
    case 'pdr':
      text = Yanfly.Param.StatusAttr_pdr;
      break;
    case 'mdr':
      text = Yanfly.Param.StatusAttr_mdr;
      break;
    case 'fdr':
      text = Yanfly.Param.StatusAttr_fdr;
      break;
    case 'exr':
      text = Yanfly.Param.StatusAttr_exr;
      break;
    default:
      break;
    }
    this.drawText(text, x, y, this._paramNameWidth);
};

Window_StatCompareExtra.prototype.getAttr = function(actor, attr) {
    var attrValue = 0;
    switch (attr) {
    case 'hit':
      attrValue = actor.hit;
      break;
    case 'eva':
      attrValue = actor.eva;
      break;
    case 'cri':
      attrValue = actor.cri;
      break;
    case 'cev':
      attrValue = actor.cev;
      break;
    case 'mev':
      attrValue = actor.mev;
      break;
    case 'mrf':
      attrValue = actor.mrf;
      break;
    case 'cnt':
      attrValue = actor.cnt;
      break;
    case 'hrg':
      attrValue = actor.hrg;
      break;
    case 'mrg':
      attrValue = actor.mrg;
      break;
    case 'trg':
      attrValue = actor.trg;
      break;
    case 'tgr':
      attrValue = actor.tgr;
      break;
    case 'grd':
      attrValue = actor.grf;
      break;
    case 'rec':
      attrValue = actor.rec;
      break;
    case 'pha':
      attrValue = actor.pha;
      break;
    case 'mcr':
      attrValue = actor.mcr;
      break;
    case 'tcr':
      attrValue = actor.tcr;
      break;
    case 'pdr':
      attrValue = actor.pdr;
      if (Imported.YEP_X_ArmorScaling) {
        var target = actor;
        var armor = eval(Yanfly.Param.ARSBPhysArmor);
        var value = 1;
        (armor >= 0) ? eval(Yanfly.Param.ARSPPhysRate) : eval(Yanfly.Param.ARSNPhysRate);
        attrValue = 1 - value * attrValue;
      }
      break;
    case 'mdr':
      attrValue = actor.mdr;
      if (Imported.YEP_X_ArmorScaling) {
        var target = actor;
        var armor = eval(Yanfly.Param.ARSBMagArmor);
        var value = 1;
        (armor >= 0) ? eval(Yanfly.Param.ARSPMagRate) : eval(Yanfly.Param.ARSNMagRate);
        attrValue = 1 - value * attrValue;
      }
      break;
    case 'fdr':
      attrValue = actor.fdr;
      break;
    case 'exr':
      attrValue = actor.exr;
      break;
    default:
      break;
    }
    return attrValue;
};

Window_StatCompareExtra.prototype.textAttributeRate = function(rate) {
    var value = (rate * 100).toFixed(Yanfly.Param.StatusAttrDec) + '%';
    return value;
};

Window_StatCompareExtra.prototype.drawCurrentParamExtra = function(y, attr) {
    var x = this.contents.width - this.textPadding();
    x -= this._paramValueWidth * 2 + this._arrowWidth + this._bonusValueWidth;
    this.resetTextColor();
    var actorparam = Yanfly.Util.toGroup(this.getAttr(this._actor, attr));
    this.drawText(this.textAttributeRate(actorparam), x, y, this._paramValueWidth, 'right');
};

Window_StatCompareExtra.prototype.drawNewParamExtra = function(y, attr) {
    var x = this.contents.width - this.textPadding();
    x -= this._paramValueWidth + this._bonusValueWidth;
    var newValue = this.getAttr(this._tempActor, attr);
    var diffvalue = newValue - this.getAttr(this._actor, attr);
    var actorparam = Yanfly.Util.toGroup(newValue);
    this.changeTextColor(this.paramchangeTextColor(diffvalue));
    this.drawText(this.textAttributeRate(actorparam), x, y, this._paramValueWidth, 'right');
};

Window_StatCompareExtra.prototype.drawParamDifferenceExtra = function(y, attr) {
    var x = this.contents.width - this.textPadding();
    x -= this._bonusValueWidth;
    var newValue = this.getAttr(this._tempActor, attr);
    var diffvalue = newValue - this.getAttr(this._actor, attr);
    if (diffvalue === 0) return;
    var actorparam = Yanfly.Util.toGroup(newValue);
    this.changeTextColor(this.paramchangeTextColor(diffvalue));
    var text = Yanfly.Util.toGroup(this.textAttributeRate(diffvalue));
    if (diffvalue > 0) {
      text = ' (+' + text + ')';
    } else {
      text = ' (' + text + ')';
    }
    this.drawText(text, x, y, this._bonusValueWidth, 'left');
};

//=============================================================================

Window_StatCompareExtra.prototype.drawItemAddition = function(x, y, attr) {
    this.drawDarkRect(x, y, this.contents.width, this.lineHeight());
    this.drawParamNameAddition(y, attr);
    this.drawCurrentParamAddition(y, attr);
    this.drawRightArrow(y);
    if (!this._tempActor) return;
    this.drawNewParamAddition(y, attr);
    this.drawParamDifferenceAddition(y, attr);
};

Window_StatCompareExtra.prototype.drawParamNameAddition = function(y, attr) {
    var x = this.textPadding();
    var text = '';
    this.changeTextColor(this.systemColor());
    switch (attr) {
    case 'atktime':
      text = LeftPlugin.Param.ParamNameAttackTimes;
      break;
    case 'alldmg':
      text = LeftPlugin.Param.ParamNameTotalDamage;
      break;
    case 'cridmg':
      text = LeftPlugin.Param.ParamNameCriticalDamage;
      break;
    case 'avgdmg':
      text = LeftPlugin.Param.ParamNameAverageDamage;
      break;
    default:
      break;
    }
    this.drawText(text, x, y, this._paramNameWidth);
};

Window_StatCompareExtra.prototype.applyCriticalMult =
  function(value, baseDamage, user) {
    var a = user;
    var s = $gameSwitches._data;
    var v = $gameVariables._data;
    var bonus = user.criticalMultiplierBonus();
    var code = Yanfly.Param.critMult;
    try {
      eval(code);
    } catch (e) {
      Yanfly.Util.displayError(e, code, 'CRITICAL MULTIPLIER ERROR');
    }
    return value;
};

Window_StatCompareExtra.prototype.applyFlatCrit = function(value, baseDamage, user) {
    var a = user;
    var s = $gameSwitches._data;
    var v = $gameVariables._data;
    var bonus = user.flatCriticalBonus();
    var code = Yanfly.Param.flatCrit;
    try {
      eval(code);
    } catch (e) {
      Yanfly.Util.displayError(e, code, 'CRITICAL FLAT BONUS ERROR');
    }
    return value;
};

Window_StatCompareExtra.prototype.getAdditionValue = function(actor, attr) {
    var additionValue = 0;
    switch (attr) {
    case 'atktime':
      additionValue = 1 + actor.attackTimesAdd();
      break;
    case 'alldmg':
      additionValue = actor.atk * (1 + actor.attackTimesAdd());
      break;
    case 'cridmg':
      if (Imported.YEP_X_CriticalControl) {
        var value = actor.atk;
        value = this.applyCriticalMult(value, actor.atk, actor);
        value = this.applyFlatCrit(value, actor.atk, actor);
        additionValue = Math.round(value);
      } else {
        additionValue = actor.atk * 3.0;
      }
      break;
    case 'avgdmg':
      if (Imported.YEP_X_CriticalControl) {
        additionValue = actor.atk;
        if (actor.hit < 1) additionValue *= actor.hit;
        if (actor.cri > 0) {
          value = actor.atk;
          value = this.applyCriticalMult(value, actor.atk, actor);
          value = this.applyFlatCrit(value, actor.atk, actor);
          var critPerReal = actor.cri.clamp(0, 1);
          additionValue = additionValue * (1 - critPerReal) + Math.round(value) * critPerReal;
        }
        additionValue *= (1 + actor.attackTimesAdd());
        additionValue = Math.round(additionValue);
      } else {
        additionValue = actor.atk * (1 + actor.attackTimesAdd());
      }
      break;
    default:
      break;
    }
    return additionValue;
};

Window_StatCompareExtra.prototype.drawCurrentParamAddition = function(y, attr) {
    var x = this.contents.width - this.textPadding();
    x -= this._paramValueWidth * 2 + this._arrowWidth + this._bonusValueWidth;
    this.resetTextColor();
    var actorparam = Yanfly.Util.toGroup(this.getAdditionValue(this._actor, attr));
    this.drawText(actorparam, x, y, this._paramValueWidth, 'right');
};

Window_StatCompareExtra.prototype.drawNewParamAddition = function(y, attr) {
    var x = this.contents.width - this.textPadding();
    x -= this._paramValueWidth + this._bonusValueWidth;
    var newValue = this.getAdditionValue(this._tempActor, attr);
    var diffvalue = newValue - this.getAdditionValue(this._actor, attr);
    var actorparam = Yanfly.Util.toGroup(newValue);
    this.changeTextColor(this.paramchangeTextColor(diffvalue));
    this.drawText(actorparam, x, y, this._paramValueWidth, 'right');
};

Window_StatCompareExtra.prototype.drawParamDifferenceAddition = function(y, attr) {
    var x = this.contents.width - this.textPadding();
    x -= this._bonusValueWidth;
    var newValue = this.getAdditionValue(this._tempActor, attr);
    var diffvalue = newValue - this.getAdditionValue(this._actor, attr);
    if (diffvalue === 0) return;
    var actorparam = Yanfly.Util.toGroup(newValue);
    this.changeTextColor(this.paramchangeTextColor(diffvalue));
    var text = Yanfly.Util.toGroup(diffvalue);
    if (diffvalue > 0) {
      text = ' (+' + text + ')';
    } else {
      text = ' (' + text + ')';
    }
    this.drawText(text, x, y, this._bonusValueWidth, 'left');
};

//=============================================================================
// Window_StatCompare
//=============================================================================

var _Window_StatCompare_initialize = Window_StatCompare.prototype.initialize;
Window_StatCompare.prototype.initialize = function(wx, wy, ww, wh) {
    _Window_StatCompare_initialize.call(this, wx, wy, ww, wh);
    this.contents.fontSize = 20;
};

Window_StatCompare.prototype.setCompareExtra = function(window) {
    this._setCompareExtra = window;
};

var _Window_StatCompare_setActor = Window_StatCompare.prototype.setActor;
Window_StatCompare.prototype.setActor = function(actor) {
    _Window_StatCompare_setActor.call(this, actor);
    if (this._setCompareExtra) this._setCompareExtra.setActor(actor);
};

var _Window_StatCompare_refresh = Window_StatCompare.prototype.refresh;
Window_StatCompare.prototype.refresh = function() {
    _Window_StatCompare_refresh.call(this);
    if (this._setCompareExtra) this._setCompareExtra.refresh();
};

var _Window_StatCompare_setTempActor = Window_StatCompare.prototype.setTempActor;
Window_StatCompare.prototype.setTempActor = function(tempActor) {
    _Window_StatCompare_setTempActor.call(this, tempActor);
    if (this._setCompareExtra) this._setCompareExtra.setTempActor(tempActor);
};

//=============================================================================
// Scene_Equip
//=============================================================================

var _Scene_Equip_createCompareWindow = Scene_Equip.prototype.createCompareWindow;
Scene_Equip.prototype.createCompareWindow = function() {
    _Scene_Equip_createCompareWindow.call(this);
    this.createCompareExtraWindow();
};

Scene_Equip.prototype.createCompareExtraWindow = function() {
    var wx = this._itemWindow.width;
    var wy = this._itemWindow.y;
    var ww = Graphics.boxWidth - wx;
    var wh = Graphics.boxHeight - wy;
    this._compareExtraWindow = new Window_StatCompareExtra(wx, wy, ww, wh);
    this._compareWindow.setCompareExtra(this._compareExtraWindow);
    this.addWindow(this._compareExtraWindow);
    this._lowerRightWindows.splice(1, 0, this._compareExtraWindow);
};

//=============================================================================

})();

// EOF
